const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_temp_detaildt', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    DT_Side: {
      type: DataTypes.STRING(10),
      allowNull: false,
      defaultValue: "0"
    },
    DT_Jar: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "NA"
    },
    DT_Temp: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue:"NA"
    },
    DT_StartDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    DT_StartTm: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    DT_EndTm: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    DT_RunTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    DT_Remark: {
      type: DataTypes.STRING(200),
      allowNull: false
    },
    DT_DoneByID: {
      type: DataTypes.STRING(50),
      allowNull: false
    },
    DT_DoneByName: {
      type: DataTypes.STRING(300),
      allowNull: false
    },
    DT_HaltDur: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Layer: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    HMIID: {
        type: DataTypes.STRING(50),
        allowNull: true
    },
    WgmtModeNo: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    ProductType: {
        type: DataTypes.INTEGER,
        allowNull: true
      },
  }, {
    sequelize,
    tableName: 'tbl_temp_detaildt',
    schema: 'dbo',
    timestamps: false
  });
  seq.removeAttribute('id');
  return seq;
};
